#ifndef SST_SEP_ATP_SPECIALDATAOPHMAC_H
#define SST_SEP_ATP_SPECIALDATAOPHMAC_H

#include "SST_SEP_TST.h"
/*
 * All the includes that are needed for code using this module to
 * compile correctly should be #included here.
 */

#ifdef __cplusplus
extern "C"
{
#endif

/*Data operations test struct*/
typedef struct TST_ATP_SpecialDataOpHMACTestDataStruct{
    char                        TST_Name[TST_NAME_STRING_LEN];
    DxByte_t                    TST_Password[TST_PASSWORD_STRING_LEN];
    DxUint32_t                  TST_PasswordSizeInBytes;
    DxUint32_t                  TST_MaxNumOfTrials;
    DxByte_t                    TST_HMACKey1[TST_HMAC_KEY_SIZE];
    DxUint32_t                  TST_HMACKey1Size;
    DxByte_t                    TST_HMACKey2[TST_HMAC_KEY_SIZE];
    DxUint32_t                  TST_HMACKey2Size;
    DxByte_t                    TST_HMACKeyTemp[TST_HMAC_KEY_SIZE];
    DxUint32_t                  TST_HMACKeyTempSize;  
    CRYS_HASH_OperationMode_t   TST_OperationMode;       
    DxUint8_t                   TST_DataIn[TST_MAX_DATA_VEC_SIZE_IN_BYTES];        
    DxUint32_t                  TST_DataInSize;         
    CRYS_HASH_Result_t          TST_DataHMAC_Result1;
    CRYS_HASH_Result_t          TST_DataHMAC_Result2;
    DxUint32_t                  TST_HASHSize;
} TST_ATP_SpecialDataOpHMACTestDataStruct;


/*****************************************************************************
 * Function Name:                                                           
 *  SEPQA_SST_SpecialDataOpHMAC        
 * 
 * Inputs:
 *  None
 *
 * Outputs:
 *  DxError_t - Function error return                                        
 *
 * Description:                                                                 
 * Test the Test the insertion, generation, reading, deletion, and usage of a HMAC key.
 *  
 * Algorithm:       
 *    1.  Create a new session by calling: SST_SessionCreate.
 *    2.  Open a transaction by calling: SST_TransactionStart.
 *    3.  Create a new password authenticator by calling: SST_AuthenticatorPasswordCreate.
 *    4.  Close the transaction by calling: SST_TransactionClose.
 *    5.  Open the authenticator by calling: SST_AuthenticationOpen.
 *    6.  Open a transaction by calling: SST_TransactionStart.
 *    7.  Create a new HMAC #1 key by calling: SST_HMACKeyGenerate.
 *    8.  Read the generated HMAC key #1 by calling: SST_HMACKeyRead.
 *    9.  Insert a HMAC #2 key to the SST by calling: SST_HMACKeyInsert. Using the data received by reading the SST key #1
 *    10.  Read the inserted HMAC key #2 by calling: SST_HMACKeyRead. And compare to data used.
 *    11.  Close the transaction by calling: SST_TransactionEnd.
 *    12.  Hash plain text by using HMAC key #1 and calling: CRYS_SST_HMAC.
 *    13.  Hash the received cipher text using HMAC key #2 by calling: CRYS_SST_HMAC and compare to the original hash result.
 *    14.  Open a transaction by calling: SST_TransactionStart.
 *    15.  Delete the HMAC keys (one by one) by calling: SST_DataDelete.
 *    16.  Close the authenticator by calling: SST_AuthenticationClose.
 *    17.  Delete the authenticator by calling: SST_AuthenticatorDelete.
 *    18.  Close the transaction by calling: SST_TransactionClose.
 *    19.  Delete the session by calling: SST_SessionDelete.                             
 *
 *******************************************************************************/    
DxError_t SEPQA_SST_SpecialDataOpHMAC ( void );



#ifdef __cplusplus
}


#endif

#endif





